/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2440;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import twilightforest.block.BanisterBlock;
import twilightforest.block.TFBlocks;
import twilightforest.util.ArrayUtil;
import twilightforest.util.FeaturePlacers;

public enum StructureWoodVariant implements class_3542
{
    OAK(class_2246.field_10161, class_2246.field_10563, class_2246.field_10119, class_2246.field_10057, class_2246.field_10620, class_2246.field_10188, class_2246.field_10484, (BanisterBlock)((Object)TFBlocks.OAK_BANISTER.get())),
    SPRUCE(class_2246.field_9975, class_2246.field_10569, class_2246.field_10071, class_2246.field_10066, class_2246.field_10020, class_2246.field_10291, class_2246.field_10332, (BanisterBlock)((Object)TFBlocks.SPRUCE_BANISTER.get())),
    BIRCH(class_2246.field_10148, class_2246.field_10408, class_2246.field_10257, class_2246.field_10417, class_2246.field_10299, class_2246.field_10513, class_2246.field_10592, (BanisterBlock)((Object)TFBlocks.BIRCH_BANISTER.get())),
    JUNGLE(class_2246.field_10334, class_2246.field_10122, class_2246.field_10617, class_2246.field_10553, class_2246.field_10319, class_2246.field_10041, class_2246.field_10026, (BanisterBlock)((Object)TFBlocks.JUNGLE_BANISTER.get())),
    ACACIA(class_2246.field_10218, class_2246.field_10256, class_2246.field_10031, class_2246.field_10278, class_2246.field_10144, class_2246.field_10457, class_2246.field_10397, (BanisterBlock)((Object)TFBlocks.ACACIA_BANISTER.get())),
    DARK_OAK(class_2246.field_10075, class_2246.field_10616, class_2246.field_10500, class_2246.field_10493, class_2246.field_10132, class_2246.field_10196, class_2246.field_10470, (BanisterBlock)((Object)TFBlocks.DARK_OAK_BANISTER.get())),
    CRIMSON(class_2246.field_22126, class_2246.field_22098, class_2246.field_22128, class_2246.field_22100, class_2246.field_22132, class_2246.field_22096, class_2246.field_22130, (BanisterBlock)((Object)TFBlocks.CRIMSON_BANISTER.get())),
    WARPED(class_2246.field_22127, class_2246.field_22099, class_2246.field_22129, class_2246.field_22101, class_2246.field_22133, class_2246.field_22097, class_2246.field_22131, (BanisterBlock)((Object)TFBlocks.WARPED_BANISTER.get())),
    TWILIGHT_OAK((Supplier<class_2248>)TFBlocks.TWILIGHT_OAK_PLANKS, (Supplier<class_2510>)TFBlocks.TWILIGHT_OAK_STAIRS, (Supplier<class_2248>)TFBlocks.TWILIGHT_OAK_SLAB, (Supplier<class_2248>)TFBlocks.TWILIGHT_OAK_BUTTON, (Supplier<class_2248>)TFBlocks.TWILIGHT_OAK_FENCE, (Supplier<class_2248>)TFBlocks.TWILIGHT_OAK_GATE, (Supplier<class_2248>)TFBlocks.TWILIGHT_OAK_PLATE, (Supplier<BanisterBlock>)TFBlocks.TWILIGHT_OAK_BANISTER),
    CANOPY((Supplier<class_2248>)TFBlocks.CANOPY_PLANKS, (Supplier<class_2510>)TFBlocks.CANOPY_STAIRS, (Supplier<class_2248>)TFBlocks.CANOPY_SLAB, (Supplier<class_2248>)TFBlocks.CANOPY_BUTTON, (Supplier<class_2248>)TFBlocks.CANOPY_FENCE, (Supplier<class_2248>)TFBlocks.CANOPY_GATE, (Supplier<class_2248>)TFBlocks.CANOPY_PLATE, (Supplier<BanisterBlock>)TFBlocks.CANOPY_BANISTER),
    MANGROVE((Supplier<class_2248>)TFBlocks.MANGROVE_PLANKS, (Supplier<class_2510>)TFBlocks.MANGROVE_STAIRS, (Supplier<class_2248>)TFBlocks.MANGROVE_SLAB, (Supplier<class_2248>)TFBlocks.MANGROVE_BUTTON, (Supplier<class_2248>)TFBlocks.MANGROVE_FENCE, (Supplier<class_2248>)TFBlocks.MANGROVE_GATE, (Supplier<class_2248>)TFBlocks.MANGROVE_PLATE, (Supplier<BanisterBlock>)TFBlocks.MANGROVE_BANISTER),
    DARK((Supplier<class_2248>)TFBlocks.DARK_PLANKS, (Supplier<class_2510>)TFBlocks.DARK_STAIRS, (Supplier<class_2248>)TFBlocks.DARK_SLAB, (Supplier<class_2248>)TFBlocks.DARK_BUTTON, (Supplier<class_2248>)TFBlocks.DARK_FENCE, (Supplier<class_2248>)TFBlocks.DARK_GATE, (Supplier<class_2248>)TFBlocks.DARK_PLATE, (Supplier<BanisterBlock>)TFBlocks.DARKWOOD_BANISTER),
    TIME((Supplier<class_2248>)TFBlocks.TIME_PLANKS, (Supplier<class_2510>)TFBlocks.TIME_STAIRS, (Supplier<class_2248>)TFBlocks.TIME_SLAB, (Supplier<class_2248>)TFBlocks.TIME_BUTTON, (Supplier<class_2248>)TFBlocks.TIME_FENCE, (Supplier<class_2248>)TFBlocks.TIME_GATE, (Supplier<class_2248>)TFBlocks.TIME_PLATE, (Supplier<BanisterBlock>)TFBlocks.TIME_BANISTER),
    TRANS((Supplier<class_2248>)TFBlocks.TRANSFORMATION_PLANKS, (Supplier<class_2510>)TFBlocks.TRANSFORMATION_STAIRS, (Supplier<class_2248>)TFBlocks.TRANSFORMATION_SLAB, (Supplier<class_2248>)TFBlocks.TRANSFORMATION_BUTTON, (Supplier<class_2248>)TFBlocks.TRANSFORMATION_FENCE, (Supplier<class_2248>)TFBlocks.TRANSFORMATION_GATE, (Supplier<class_2248>)TFBlocks.TRANSFORMATION_PLATE, (Supplier<BanisterBlock>)TFBlocks.TRANSFORMATION_BANISTER),
    MINE((Supplier<class_2248>)TFBlocks.MINING_PLANKS, (Supplier<class_2510>)TFBlocks.MINING_STAIRS, (Supplier<class_2248>)TFBlocks.MINING_SLAB, (Supplier<class_2248>)TFBlocks.MINING_BUTTON, (Supplier<class_2248>)TFBlocks.MINING_FENCE, (Supplier<class_2248>)TFBlocks.MINING_GATE, (Supplier<class_2248>)TFBlocks.MINING_PLATE, (Supplier<BanisterBlock>)TFBlocks.MINING_BANISTER),
    SORT((Supplier<class_2248>)TFBlocks.SORTING_PLANKS, (Supplier<class_2510>)TFBlocks.SORTING_STAIRS, (Supplier<class_2248>)TFBlocks.SORTING_SLAB, (Supplier<class_2248>)TFBlocks.SORTING_BUTTON, (Supplier<class_2248>)TFBlocks.SORTING_FENCE, (Supplier<class_2248>)TFBlocks.SORTING_GATE, (Supplier<class_2248>)TFBlocks.SORTING_PLATE, (Supplier<BanisterBlock>)TFBlocks.SORTING_BANISTER);

    private final List<class_2248> blocks;
    private static final StructureWoodVariant[] COMMON;
    private static final StructureWoodVariant[] UNCOMMON;
    private static final StructureWoodVariant[] RARE;
    private static final StructureWoodVariant[] TREASURE;
    private final class_2248 planks;
    private final class_2248 stairs;
    private final class_2248 slab;
    private final class_2248 button;
    private final class_2248 fence;
    private final class_2248 gate;
    private final class_2248 plate;
    private final BanisterBlock banister;

    private StructureWoodVariant(Supplier<class_2248> planks, Supplier<class_2510> stairs, Supplier<class_2248> slab, Supplier<class_2248> button, Supplier<class_2248> fence, Supplier<class_2248> gate, Supplier<class_2248> plate, Supplier<BanisterBlock> banister) {
        this(planks.get(), (class_2248)stairs.get(), slab.get(), button.get(), fence.get(), gate.get(), plate.get(), banister.get());
    }

    private StructureWoodVariant(class_2248 planks, class_2248 stairs, class_2248 slab, class_2248 button, class_2248 fence, class_2248 gate, class_2248 plate, BanisterBlock banister) {
        this.planks = planks;
        this.stairs = stairs;
        this.slab = slab;
        this.button = button;
        this.fence = fence;
        this.gate = gate;
        this.plate = plate;
        this.banister = banister;
        this.blocks = Arrays.asList(new class_2248[]{this.planks, this.stairs, this.slab, this.button, this.fence, this.gate, this.plate, this.banister});
    }

    public static StructureWoodVariant getRandomWeighted(Random random) {
        int randomVal = random.nextInt() & Integer.MAX_VALUE;
        if ((randomVal & 1) == 0) {
            return ArrayUtil.wrapped(COMMON, randomVal >> 1);
        }
        if ((randomVal & 2) == 0) {
            return ArrayUtil.wrapped(UNCOMMON, randomVal >> 2);
        }
        if ((randomVal & 0xC) != 0) {
            return ArrayUtil.wrapped(RARE, randomVal >> 4);
        }
        return ArrayUtil.wrapped(TREASURE, randomVal >> 4);
    }

    public String method_15434() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static StructureWoodVariant getVariantFromBlock(class_2248 block) {
        for (StructureWoodVariant var : StructureWoodVariant.values()) {
            if (!var.blocks.contains(block)) continue;
            return var;
        }
        return null;
    }

    public static boolean isPlanks(class_2248 block) {
        StructureWoodVariant var = StructureWoodVariant.getVariantFromBlock(block);
        if (var == null) {
            return false;
        }
        return var.planks == block;
    }

    public static class_2680 modifyBlockWithType(class_2680 stateIn, StructureWoodVariant target) {
        class_2248 block = stateIn.method_26204();
        WoodShapes shape = StructureWoodVariant.getWoodShapeFromBlock(block);
        class_2960 blockRegName = class_2378.field_11146.method_10221((Object)block);
        if (blockRegName == null) {
            return stateIn;
        }
        if (shape == WoodShapes.INVALID || !"minecraft".equals(blockRegName.method_12836()) && !"twilightforest".equals(blockRegName.method_12836())) {
            return stateIn;
        }
        return switch (shape) {
            case WoodShapes.BLOCK -> target.planks.method_9564();
            case WoodShapes.STAIRS -> FeaturePlacers.transferAllStateKeys(stateIn, target.stairs);
            case WoodShapes.SLAB -> FeaturePlacers.transferAllStateKeys(stateIn, target.slab);
            case WoodShapes.FENCE -> FeaturePlacers.transferAllStateKeys(stateIn, target.fence);
            case WoodShapes.GATE -> FeaturePlacers.transferAllStateKeys(stateIn, target.gate);
            case WoodShapes.BUTTON -> FeaturePlacers.transferAllStateKeys(stateIn, target.button);
            case WoodShapes.PLATE -> FeaturePlacers.transferAllStateKeys(stateIn, target.plate);
            case WoodShapes.BANISTER -> FeaturePlacers.transferAllStateKeys(stateIn, (class_2248)target.banister);
            default -> stateIn;
        };
    }

    public static WoodShapes getWoodShapeFromBlock(class_2248 b) {
        if (StructureWoodVariant.isPlanks(b)) {
            return WoodShapes.BLOCK;
        }
        if (b instanceof class_2510) {
            return WoodShapes.STAIRS;
        }
        if (b instanceof class_2482) {
            return WoodShapes.SLAB;
        }
        if (b instanceof class_2269) {
            return WoodShapes.BUTTON;
        }
        if (b instanceof class_2354) {
            return WoodShapes.FENCE;
        }
        if (b instanceof class_2349) {
            return WoodShapes.GATE;
        }
        if (b instanceof class_2440) {
            return WoodShapes.PLATE;
        }
        if (b instanceof BanisterBlock) {
            return WoodShapes.BANISTER;
        }
        return WoodShapes.INVALID;
    }

    static {
        COMMON = new StructureWoodVariant[]{SPRUCE, CANOPY};
        UNCOMMON = new StructureWoodVariant[]{OAK, DARK_OAK, TWILIGHT_OAK};
        RARE = new StructureWoodVariant[]{BIRCH, JUNGLE, MANGROVE};
        TREASURE = new StructureWoodVariant[]{TIME, TRANS, MINE, SORT};
    }

    public static enum WoodShapes {
        BLOCK,
        STAIRS,
        SLAB,
        BUTTON,
        FENCE,
        GATE,
        PLATE,
        BANISTER,
        INVALID;

    }
}

